/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;

@SdkInternalApi
public class RecordDetailMarshaller {
    private static final MarshallingInfo<String> RECORDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordId").build();
    private static final MarshallingInfo<String> PROVISIONEDPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedProductName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").build();
    private static final MarshallingInfo<Instant> UPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTime").build();
    private static final MarshallingInfo<String> PROVISIONEDPRODUCTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedProductType").build();
    private static final MarshallingInfo<String> RECORDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordType").build();
    private static final MarshallingInfo<String> PROVISIONEDPRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedProductId").build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").build();
    private static final MarshallingInfo<String> PATHID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PathId").build();
    private static final MarshallingInfo<List> RECORDERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordErrors").build();
    private static final MarshallingInfo<List> RECORDTAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordTags").build();
    private static final RecordDetailMarshaller INSTANCE = new RecordDetailMarshaller();

    public static RecordDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordDetail recordDetail, ProtocolMarshaller protocolMarshaller) {
        if (recordDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recordDetail.recordId(), RECORDID_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.provisionedProductName(), PROVISIONEDPRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.updatedTime(), UPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.provisionedProductType(), PROVISIONEDPRODUCTTYPE_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.recordType(), RECORDTYPE_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.provisionedProductId(), PROVISIONEDPRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
            protocolMarshaller.marshall((Object)recordDetail.pathId(), PATHID_BINDING);
            protocolMarshaller.marshall(recordDetail.recordErrors(), RECORDERRORS_BINDING);
            protocolMarshaller.marshall(recordDetail.recordTags(), RECORDTAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

