/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScanProvisionedProductsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ScanProvisionedProductsRequest> {
    private final String acceptLanguage;
    private final AccessLevelFilter accessLevelFilter;
    private final Integer pageSize;
    private final String pageToken;

    private ScanProvisionedProductsRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public AccessLevelFilter accessLevelFilter() {
        return this.accessLevelFilter;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.accessLevelFilter() == null ? 0 : this.accessLevelFilter().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        hashCode = 31 * hashCode + (this.pageToken() == null ? 0 : this.pageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanProvisionedProductsRequest)) {
            return false;
        }
        ScanProvisionedProductsRequest other = (ScanProvisionedProductsRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.accessLevelFilter() == null ^ this.accessLevelFilter() == null) {
            return false;
        }
        if (other.accessLevelFilter() != null && !other.accessLevelFilter().equals(this.accessLevelFilter())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        if (other.pageSize() != null && !other.pageSize().equals(this.pageSize())) {
            return false;
        }
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        return other.pageToken() == null || other.pageToken().equals(this.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.accessLevelFilter() != null) {
            sb.append("AccessLevelFilter: ").append(this.accessLevelFilter()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "AccessLevelFilter": {
                return Optional.of(clazz.cast(this.accessLevelFilter()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private AccessLevelFilter accessLevelFilter;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanProvisionedProductsRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.accessLevelFilter(model.accessLevelFilter);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return this.accessLevelFilter != null ? this.accessLevelFilter.toBuilder() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public ScanProvisionedProductsRequest build() {
            return new ScanProvisionedProductsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScanProvisionedProductsRequest> {
        public Builder acceptLanguage(String var1);

        public Builder accessLevelFilter(AccessLevelFilter var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);
    }
}

