/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.RecordError;
import software.amazon.awssdk.services.servicecatalog.model.RecordErrorsCopier;
import software.amazon.awssdk.services.servicecatalog.model.RecordStatus;
import software.amazon.awssdk.services.servicecatalog.model.RecordTag;
import software.amazon.awssdk.services.servicecatalog.model.RecordTagsCopier;
import software.amazon.awssdk.services.servicecatalog.transform.RecordDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordDetail> {
    private final String recordId;
    private final String provisionedProductName;
    private final String status;
    private final Instant createdTime;
    private final Instant updatedTime;
    private final String provisionedProductType;
    private final String recordType;
    private final String provisionedProductId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final List<RecordError> recordErrors;
    private final List<RecordTag> recordTags;

    private RecordDetail(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.provisionedProductName = builder.provisionedProductName;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.provisionedProductType = builder.provisionedProductType;
        this.recordType = builder.recordType;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.recordErrors = builder.recordErrors;
        this.recordTags = builder.recordTags;
    }

    public String recordId() {
        return this.recordId;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public RecordStatus status() {
        return RecordStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant updatedTime() {
        return this.updatedTime;
    }

    public String provisionedProductType() {
        return this.provisionedProductType;
    }

    public String recordType() {
        return this.recordType;
    }

    public String provisionedProductId() {
        return this.provisionedProductId;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    public List<RecordError> recordErrors() {
        return this.recordErrors;
    }

    public List<RecordTag> recordTags() {
        return this.recordTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordId() == null ? 0 : this.recordId().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductName() == null ? 0 : this.provisionedProductName().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.updatedTime() == null ? 0 : this.updatedTime().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductType() == null ? 0 : this.provisionedProductType().hashCode());
        hashCode = 31 * hashCode + (this.recordType() == null ? 0 : this.recordType().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductId() == null ? 0 : this.provisionedProductId().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactId() == null ? 0 : this.provisioningArtifactId().hashCode());
        hashCode = 31 * hashCode + (this.pathId() == null ? 0 : this.pathId().hashCode());
        hashCode = 31 * hashCode + (this.recordErrors() == null ? 0 : this.recordErrors().hashCode());
        hashCode = 31 * hashCode + (this.recordTags() == null ? 0 : this.recordTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordDetail)) {
            return false;
        }
        RecordDetail other = (RecordDetail)obj;
        if (other.recordId() == null ^ this.recordId() == null) {
            return false;
        }
        if (other.recordId() != null && !other.recordId().equals(this.recordId())) {
            return false;
        }
        if (other.provisionedProductName() == null ^ this.provisionedProductName() == null) {
            return false;
        }
        if (other.provisionedProductName() != null && !other.provisionedProductName().equals(this.provisionedProductName())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.updatedTime() == null ^ this.updatedTime() == null) {
            return false;
        }
        if (other.updatedTime() != null && !other.updatedTime().equals(this.updatedTime())) {
            return false;
        }
        if (other.provisionedProductType() == null ^ this.provisionedProductType() == null) {
            return false;
        }
        if (other.provisionedProductType() != null && !other.provisionedProductType().equals(this.provisionedProductType())) {
            return false;
        }
        if (other.recordType() == null ^ this.recordType() == null) {
            return false;
        }
        if (other.recordType() != null && !other.recordType().equals(this.recordType())) {
            return false;
        }
        if (other.provisionedProductId() == null ^ this.provisionedProductId() == null) {
            return false;
        }
        if (other.provisionedProductId() != null && !other.provisionedProductId().equals(this.provisionedProductId())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.provisioningArtifactId() == null ^ this.provisioningArtifactId() == null) {
            return false;
        }
        if (other.provisioningArtifactId() != null && !other.provisioningArtifactId().equals(this.provisioningArtifactId())) {
            return false;
        }
        if (other.pathId() == null ^ this.pathId() == null) {
            return false;
        }
        if (other.pathId() != null && !other.pathId().equals(this.pathId())) {
            return false;
        }
        if (other.recordErrors() == null ^ this.recordErrors() == null) {
            return false;
        }
        if (other.recordErrors() != null && !other.recordErrors().equals(this.recordErrors())) {
            return false;
        }
        if (other.recordTags() == null ^ this.recordTags() == null) {
            return false;
        }
        return other.recordTags() == null || other.recordTags().equals(this.recordTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recordId() != null) {
            sb.append("RecordId: ").append(this.recordId()).append(",");
        }
        if (this.provisionedProductName() != null) {
            sb.append("ProvisionedProductName: ").append(this.provisionedProductName()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.updatedTime() != null) {
            sb.append("UpdatedTime: ").append(this.updatedTime()).append(",");
        }
        if (this.provisionedProductType() != null) {
            sb.append("ProvisionedProductType: ").append(this.provisionedProductType()).append(",");
        }
        if (this.recordType() != null) {
            sb.append("RecordType: ").append(this.recordType()).append(",");
        }
        if (this.provisionedProductId() != null) {
            sb.append("ProvisionedProductId: ").append(this.provisionedProductId()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.provisioningArtifactId() != null) {
            sb.append("ProvisioningArtifactId: ").append(this.provisioningArtifactId()).append(",");
        }
        if (this.pathId() != null) {
            sb.append("PathId: ").append(this.pathId()).append(",");
        }
        if (this.recordErrors() != null) {
            sb.append("RecordErrors: ").append(this.recordErrors()).append(",");
        }
        if (this.recordTags() != null) {
            sb.append("RecordTags: ").append(this.recordTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.of(clazz.cast(this.recordId()));
            }
            case "ProvisionedProductName": {
                return Optional.of(clazz.cast(this.provisionedProductName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.of(clazz.cast(this.updatedTime()));
            }
            case "ProvisionedProductType": {
                return Optional.of(clazz.cast(this.provisionedProductType()));
            }
            case "RecordType": {
                return Optional.of(clazz.cast(this.recordType()));
            }
            case "ProvisionedProductId": {
                return Optional.of(clazz.cast(this.provisionedProductId()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.of(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.of(clazz.cast(this.pathId()));
            }
            case "RecordErrors": {
                return Optional.of(clazz.cast(this.recordErrors()));
            }
            case "RecordTags": {
                return Optional.of(clazz.cast(this.recordTags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordId;
        private String provisionedProductName;
        private String status;
        private Instant createdTime;
        private Instant updatedTime;
        private String provisionedProductType;
        private String recordType;
        private String provisionedProductId;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private List<RecordError> recordErrors;
        private List<RecordTag> recordTags;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordDetail model) {
            this.recordId(model.recordId);
            this.provisionedProductName(model.provisionedProductName);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
            this.provisionedProductType(model.provisionedProductType);
            this.recordType(model.recordType);
            this.provisionedProductId(model.provisionedProductId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
            this.recordErrors(model.recordErrors);
            this.recordTags(model.recordTags);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecordStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        public final String getProvisionedProductType() {
            return this.provisionedProductType;
        }

        @Override
        public final Builder provisionedProductType(String provisionedProductType) {
            this.provisionedProductType = provisionedProductType;
            return this;
        }

        public final void setProvisionedProductType(String provisionedProductType) {
            this.provisionedProductType = provisionedProductType;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final Collection<RecordError.Builder> getRecordErrors() {
            return this.recordErrors != null ? (Collection)this.recordErrors.stream().map(RecordError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordErrors(Collection<RecordError> recordErrors) {
            this.recordErrors = RecordErrorsCopier.copy(recordErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordErrors(RecordError ... recordErrors) {
            this.recordErrors(Arrays.asList(recordErrors));
            return this;
        }

        public final void setRecordErrors(Collection<RecordError.BuilderImpl> recordErrors) {
            this.recordErrors = RecordErrorsCopier.copyFromBuilder(recordErrors);
        }

        public final Collection<RecordTag.Builder> getRecordTags() {
            return this.recordTags != null ? (Collection)this.recordTags.stream().map(RecordTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordTags(Collection<RecordTag> recordTags) {
            this.recordTags = RecordTagsCopier.copy(recordTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordTags(RecordTag ... recordTags) {
            this.recordTags(Arrays.asList(recordTags));
            return this;
        }

        public final void setRecordTags(Collection<RecordTag.BuilderImpl> recordTags) {
            this.recordTags = RecordTagsCopier.copyFromBuilder(recordTags);
        }

        public RecordDetail build() {
            return new RecordDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordDetail> {
        public Builder recordId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder status(String var1);

        public Builder status(RecordStatus var1);

        public Builder createdTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder provisionedProductType(String var1);

        public Builder recordType(String var1);

        public Builder provisionedProductId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder recordErrors(Collection<RecordError> var1);

        public Builder recordErrors(RecordError ... var1);

        public Builder recordTags(Collection<RecordTag> var1);

        public Builder recordTags(RecordTag ... var1);
    }
}

