/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProvisioningArtifactsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListProvisioningArtifactsResponse> {
    private final List<ProvisioningArtifactDetail> provisioningArtifactDetails;
    private final String nextPageToken;

    private ListProvisioningArtifactsResponse(BuilderImpl builder) {
        this.provisioningArtifactDetails = builder.provisioningArtifactDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProvisioningArtifactDetail> provisioningArtifactDetails() {
        return this.provisioningArtifactDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.provisioningArtifactDetails() == null ? 0 : this.provisioningArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsResponse)) {
            return false;
        }
        ListProvisioningArtifactsResponse other = (ListProvisioningArtifactsResponse)((Object)obj);
        if (other.provisioningArtifactDetails() == null ^ this.provisioningArtifactDetails() == null) {
            return false;
        }
        if (other.provisioningArtifactDetails() != null && !other.provisioningArtifactDetails().equals(this.provisioningArtifactDetails())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.provisioningArtifactDetails() != null) {
            sb.append("ProvisioningArtifactDetails: ").append(this.provisioningArtifactDetails()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactDetails": {
                return Optional.of(clazz.cast(this.provisioningArtifactDetails()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactDetail> provisioningArtifactDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsResponse model) {
            this.provisioningArtifactDetails(model.provisioningArtifactDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisioningArtifactDetail.Builder> getProvisioningArtifactDetails() {
            return this.provisioningArtifactDetails != null ? (Collection)this.provisioningArtifactDetails.stream().map(ProvisioningArtifactDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copy(provisioningArtifactDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactDetails(ProvisioningArtifactDetail ... provisioningArtifactDetails) {
            this.provisioningArtifactDetails(Arrays.asList(provisioningArtifactDetails));
            return this;
        }

        public final void setProvisioningArtifactDetails(Collection<ProvisioningArtifactDetail.BuilderImpl> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copyFromBuilder(provisioningArtifactDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListProvisioningArtifactsResponse build() {
            return new ListProvisioningArtifactsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProvisioningArtifactsResponse> {
        public Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> var1);

        public Builder provisioningArtifactDetails(ProvisioningArtifactDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

