/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.services.servicecatalog.transform.LaunchPathSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchPathSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, LaunchPathSummary> {
    private final String id;
    private final List<ConstraintSummary> constraintSummaries;
    private final List<Tag> tags;
    private final String name;

    private LaunchPathSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.constraintSummaries = builder.constraintSummaries;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    public String id() {
        return this.id;
    }

    public List<ConstraintSummary> constraintSummaries() {
        return this.constraintSummaries;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.constraintSummaries() == null ? 0 : this.constraintSummaries().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPathSummary)) {
            return false;
        }
        LaunchPathSummary other = (LaunchPathSummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.constraintSummaries() == null ^ this.constraintSummaries() == null) {
            return false;
        }
        if (other.constraintSummaries() != null && !other.constraintSummaries().equals(this.constraintSummaries())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.constraintSummaries() != null) {
            sb.append("ConstraintSummaries: ").append(this.constraintSummaries()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ConstraintSummaries": {
                return Optional.of(clazz.cast(this.constraintSummaries()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchPathSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<ConstraintSummary> constraintSummaries;
        private List<Tag> tags;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPathSummary model) {
            this.id(model.id);
            this.constraintSummaries(model.constraintSummaries);
            this.tags(model.tags);
            this.name(model.name);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<ConstraintSummary.Builder> getConstraintSummaries() {
            return this.constraintSummaries != null ? (Collection)this.constraintSummaries.stream().map(ConstraintSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary ... constraintSummaries) {
            this.constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public LaunchPathSummary build() {
            return new LaunchPathSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchPathSummary> {
        public Builder id(String var1);

        public Builder constraintSummaries(Collection<ConstraintSummary> var1);

        public Builder constraintSummaries(ConstraintSummary ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder name(String var1);
    }
}

