/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeProvisioningArtifactRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeProvisioningArtifactRequest> {
    private final String acceptLanguage;
    private final String provisioningArtifactId;
    private final String productId;
    private final Boolean verbose;

    private DescribeProvisioningArtifactRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.productId = builder.productId;
        this.verbose = builder.verbose;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String productId() {
        return this.productId;
    }

    public Boolean verbose() {
        return this.verbose;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactId() == null ? 0 : this.provisioningArtifactId().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.verbose() == null ? 0 : this.verbose().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningArtifactRequest)) {
            return false;
        }
        DescribeProvisioningArtifactRequest other = (DescribeProvisioningArtifactRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.provisioningArtifactId() == null ^ this.provisioningArtifactId() == null) {
            return false;
        }
        if (other.provisioningArtifactId() != null && !other.provisioningArtifactId().equals(this.provisioningArtifactId())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.verbose() == null ^ this.verbose() == null) {
            return false;
        }
        return other.verbose() == null || other.verbose().equals(this.verbose());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.provisioningArtifactId() != null) {
            sb.append("ProvisioningArtifactId: ").append(this.provisioningArtifactId()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.verbose() != null) {
            sb.append("Verbose: ").append(this.verbose()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisioningArtifactId": {
                return Optional.of(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "Verbose": {
                return Optional.of(clazz.cast(this.verbose()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisioningArtifactId;
        private String productId;
        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningArtifactRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.productId(model.productId);
            this.verbose(model.verbose);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        public DescribeProvisioningArtifactRequest build() {
            return new DescribeProvisioningArtifactRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeProvisioningArtifactRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder productId(String var1);

        public Builder verbose(Boolean var1);
    }
}

