/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeProductAsAdminResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeProductAsAdminResponse> {
    private final ProductViewDetail productViewDetail;
    private final List<ProvisioningArtifactSummary> provisioningArtifactSummaries;
    private final List<Tag> tags;

    private DescribeProductAsAdminResponse(BuilderImpl builder) {
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactSummaries = builder.provisioningArtifactSummaries;
        this.tags = builder.tags;
    }

    public ProductViewDetail productViewDetail() {
        return this.productViewDetail;
    }

    public List<ProvisioningArtifactSummary> provisioningArtifactSummaries() {
        return this.provisioningArtifactSummaries;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productViewDetail() == null ? 0 : this.productViewDetail().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactSummaries() == null ? 0 : this.provisioningArtifactSummaries().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductAsAdminResponse)) {
            return false;
        }
        DescribeProductAsAdminResponse other = (DescribeProductAsAdminResponse)((Object)obj);
        if (other.productViewDetail() == null ^ this.productViewDetail() == null) {
            return false;
        }
        if (other.productViewDetail() != null && !other.productViewDetail().equals(this.productViewDetail())) {
            return false;
        }
        if (other.provisioningArtifactSummaries() == null ^ this.provisioningArtifactSummaries() == null) {
            return false;
        }
        if (other.provisioningArtifactSummaries() != null && !other.provisioningArtifactSummaries().equals(this.provisioningArtifactSummaries())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.productViewDetail() != null) {
            sb.append("ProductViewDetail: ").append(this.productViewDetail()).append(",");
        }
        if (this.provisioningArtifactSummaries() != null) {
            sb.append("ProvisioningArtifactSummaries: ").append(this.provisioningArtifactSummaries()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetail": {
                return Optional.of(clazz.cast(this.productViewDetail()));
            }
            case "ProvisioningArtifactSummaries": {
                return Optional.of(clazz.cast(this.provisioningArtifactSummaries()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewDetail productViewDetail;
        private List<ProvisioningArtifactSummary> provisioningArtifactSummaries;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductAsAdminResponse model) {
            this.productViewDetail(model.productViewDetail);
            this.provisioningArtifactSummaries(model.provisioningArtifactSummaries);
            this.tags(model.tags);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return this.productViewDetail != null ? this.productViewDetail.toBuilder() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        public final Collection<ProvisioningArtifactSummary.Builder> getProvisioningArtifactSummaries() {
            return this.provisioningArtifactSummaries != null ? (Collection)this.provisioningArtifactSummaries.stream().map(ProvisioningArtifactSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copy(provisioningArtifactSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(ProvisioningArtifactSummary ... provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries(Arrays.asList(provisioningArtifactSummaries));
            return this;
        }

        public final void setProvisioningArtifactSummaries(Collection<ProvisioningArtifactSummary.BuilderImpl> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copyFromBuilder(provisioningArtifactSummaries);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public DescribeProductAsAdminResponse build() {
            return new DescribeProductAsAdminResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeProductAsAdminResponse> {
        public Builder productViewDetail(ProductViewDetail var1);

        public Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> var1);

        public Builder provisioningArtifactSummaries(ProvisioningArtifactSummary ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

