/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProductResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateProductResponse> {
    private final ProductViewDetail productViewDetail;
    private final ProvisioningArtifactDetail provisioningArtifactDetail;
    private final List<Tag> tags;

    private CreateProductResponse(BuilderImpl builder) {
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactDetail = builder.provisioningArtifactDetail;
        this.tags = builder.tags;
    }

    public ProductViewDetail productViewDetail() {
        return this.productViewDetail;
    }

    public ProvisioningArtifactDetail provisioningArtifactDetail() {
        return this.provisioningArtifactDetail;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productViewDetail() == null ? 0 : this.productViewDetail().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactDetail() == null ? 0 : this.provisioningArtifactDetail().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductResponse)) {
            return false;
        }
        CreateProductResponse other = (CreateProductResponse)((Object)obj);
        if (other.productViewDetail() == null ^ this.productViewDetail() == null) {
            return false;
        }
        if (other.productViewDetail() != null && !other.productViewDetail().equals(this.productViewDetail())) {
            return false;
        }
        if (other.provisioningArtifactDetail() == null ^ this.provisioningArtifactDetail() == null) {
            return false;
        }
        if (other.provisioningArtifactDetail() != null && !other.provisioningArtifactDetail().equals(this.provisioningArtifactDetail())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.productViewDetail() != null) {
            sb.append("ProductViewDetail: ").append(this.productViewDetail()).append(",");
        }
        if (this.provisioningArtifactDetail() != null) {
            sb.append("ProvisioningArtifactDetail: ").append(this.provisioningArtifactDetail()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetail": {
                return Optional.of(clazz.cast(this.productViewDetail()));
            }
            case "ProvisioningArtifactDetail": {
                return Optional.of(clazz.cast(this.provisioningArtifactDetail()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewDetail productViewDetail;
        private ProvisioningArtifactDetail provisioningArtifactDetail;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductResponse model) {
            this.productViewDetail(model.productViewDetail);
            this.provisioningArtifactDetail(model.provisioningArtifactDetail);
            this.tags(model.tags);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return this.productViewDetail != null ? this.productViewDetail.toBuilder() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        public final ProvisioningArtifactDetail.Builder getProvisioningArtifactDetail() {
            return this.provisioningArtifactDetail != null ? this.provisioningArtifactDetail.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail;
            return this;
        }

        public final void setProvisioningArtifactDetail(ProvisioningArtifactDetail.BuilderImpl provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail != null ? provisioningArtifactDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public CreateProductResponse build() {
            return new CreateProductResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateProductResponse> {
        public Builder productViewDetail(ProductViewDetail var1);

        public Builder provisioningArtifactDetail(ProvisioningArtifactDetail var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

