/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateProductWithPortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateProductWithPortfolioRequest> {
    private final String acceptLanguage;
    private final String productId;
    private final String portfolioId;
    private final String sourcePortfolioId;

    private AssociateProductWithPortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.portfolioId = builder.portfolioId;
        this.sourcePortfolioId = builder.sourcePortfolioId;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String sourcePortfolioId() {
        return this.sourcePortfolioId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.portfolioId() == null ? 0 : this.portfolioId().hashCode());
        hashCode = 31 * hashCode + (this.sourcePortfolioId() == null ? 0 : this.sourcePortfolioId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateProductWithPortfolioRequest)) {
            return false;
        }
        AssociateProductWithPortfolioRequest other = (AssociateProductWithPortfolioRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.portfolioId() == null ^ this.portfolioId() == null) {
            return false;
        }
        if (other.portfolioId() != null && !other.portfolioId().equals(this.portfolioId())) {
            return false;
        }
        if (other.sourcePortfolioId() == null ^ this.sourcePortfolioId() == null) {
            return false;
        }
        return other.sourcePortfolioId() == null || other.sourcePortfolioId().equals(this.sourcePortfolioId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.sourcePortfolioId() != null) {
            sb.append("SourcePortfolioId: ").append(this.sourcePortfolioId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "SourcePortfolioId": {
                return Optional.of(clazz.cast(this.sourcePortfolioId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String portfolioId;
        private String sourcePortfolioId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateProductWithPortfolioRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.portfolioId(model.portfolioId);
            this.sourcePortfolioId(model.sourcePortfolioId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getSourcePortfolioId() {
            return this.sourcePortfolioId;
        }

        @Override
        public final Builder sourcePortfolioId(String sourcePortfolioId) {
            this.sourcePortfolioId = sourcePortfolioId;
            return this;
        }

        public final void setSourcePortfolioId(String sourcePortfolioId) {
            this.sourcePortfolioId = sourcePortfolioId;
        }

        public AssociateProductWithPortfolioRequest build() {
            return new AssociateProductWithPortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateProductWithPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder portfolioId(String var1);

        public Builder sourcePortfolioId(String var1);
    }
}

