/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisioningArtifactPropertiesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisioningArtifactProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisioningArtifactProperties> {
    private final String name;
    private final String description;
    private final Map<String, String> info;
    private final String type;

    private ProvisioningArtifactProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.info = builder.info;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Map<String, String> info() {
        return this.info;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.info() == null ? 0 : this.info().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactProperties)) {
            return false;
        }
        ProvisioningArtifactProperties other = (ProvisioningArtifactProperties)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.info() == null ^ this.info() == null) {
            return false;
        }
        if (other.info() != null && !other.info().equals(this.info())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.info() != null) {
            sb.append("Info: ").append(this.info()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisioningArtifactPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> info;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactProperties model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setInfo(model.info);
            this.setType(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getInfo() {
            return this.info;
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ProvisioningArtifactProperties build() {
            return new ProvisioningArtifactProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisioningArtifactProperties> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder info(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(ProvisioningArtifactType var1);
    }
}

