/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProvisioningArtifactRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateProvisioningArtifactRequest> {
    private final String acceptLanguage;
    private final String productId;
    private final ProvisioningArtifactProperties parameters;
    private final String idempotencyToken;

    private CreateProvisioningArtifactRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.parameters = builder.parameters;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public ProvisioningArtifactProperties parameters() {
        return this.parameters;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningArtifactRequest)) {
            return false;
        }
        CreateProvisioningArtifactRequest other = (CreateProvisioningArtifactRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        return other.idempotencyToken() == null || other.idempotencyToken().equals(this.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private ProvisioningArtifactProperties parameters;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningArtifactRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setProductId(model.productId);
            this.setParameters(model.parameters);
            this.setIdempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final ProvisioningArtifactProperties getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(ProvisioningArtifactProperties parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(ProvisioningArtifactProperties parameters) {
            this.parameters = parameters;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreateProvisioningArtifactRequest build() {
            return new CreateProvisioningArtifactRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateProvisioningArtifactRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder parameters(ProvisioningArtifactProperties var1);

        public Builder idempotencyToken(String var1);
    }
}

