/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductType;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProductRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateProductRequest> {
    private final String acceptLanguage;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final String productType;
    private final List<Tag> tags;
    private final ProvisioningArtifactProperties provisioningArtifactParameters;
    private final String idempotencyToken;

    private CreateProductRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.productType = builder.productType;
        this.tags = builder.tags;
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public String description() {
        return this.description;
    }

    public String distributor() {
        return this.distributor;
    }

    public String supportDescription() {
        return this.supportDescription;
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public String supportUrl() {
        return this.supportUrl;
    }

    public String productType() {
        return this.productType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public ProvisioningArtifactProperties provisioningArtifactParameters() {
        return this.provisioningArtifactParameters;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.distributor() == null ? 0 : this.distributor().hashCode());
        hashCode = 31 * hashCode + (this.supportDescription() == null ? 0 : this.supportDescription().hashCode());
        hashCode = 31 * hashCode + (this.supportEmail() == null ? 0 : this.supportEmail().hashCode());
        hashCode = 31 * hashCode + (this.supportUrl() == null ? 0 : this.supportUrl().hashCode());
        hashCode = 31 * hashCode + (this.productType() == null ? 0 : this.productType().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactParameters() == null ? 0 : this.provisioningArtifactParameters().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProductRequest)) {
            return false;
        }
        CreateProductRequest other = (CreateProductRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.distributor() == null ^ this.distributor() == null) {
            return false;
        }
        if (other.distributor() != null && !other.distributor().equals(this.distributor())) {
            return false;
        }
        if (other.supportDescription() == null ^ this.supportDescription() == null) {
            return false;
        }
        if (other.supportDescription() != null && !other.supportDescription().equals(this.supportDescription())) {
            return false;
        }
        if (other.supportEmail() == null ^ this.supportEmail() == null) {
            return false;
        }
        if (other.supportEmail() != null && !other.supportEmail().equals(this.supportEmail())) {
            return false;
        }
        if (other.supportUrl() == null ^ this.supportUrl() == null) {
            return false;
        }
        if (other.supportUrl() != null && !other.supportUrl().equals(this.supportUrl())) {
            return false;
        }
        if (other.productType() == null ^ this.productType() == null) {
            return false;
        }
        if (other.productType() != null && !other.productType().equals(this.productType())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.provisioningArtifactParameters() == null ^ this.provisioningArtifactParameters() == null) {
            return false;
        }
        if (other.provisioningArtifactParameters() != null && !other.provisioningArtifactParameters().equals(this.provisioningArtifactParameters())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        return other.idempotencyToken() == null || other.idempotencyToken().equals(this.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.distributor() != null) {
            sb.append("Distributor: ").append(this.distributor()).append(",");
        }
        if (this.supportDescription() != null) {
            sb.append("SupportDescription: ").append(this.supportDescription()).append(",");
        }
        if (this.supportEmail() != null) {
            sb.append("SupportEmail: ").append(this.supportEmail()).append(",");
        }
        if (this.supportUrl() != null) {
            sb.append("SupportUrl: ").append(this.supportUrl()).append(",");
        }
        if (this.productType() != null) {
            sb.append("ProductType: ").append(this.productType()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.provisioningArtifactParameters() != null) {
            sb.append("ProvisioningArtifactParameters: ").append(this.provisioningArtifactParameters()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private String productType;
        private List<Tag> tags;
        private ProvisioningArtifactProperties provisioningArtifactParameters;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProductRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setName(model.name);
            this.setOwner(model.owner);
            this.setDescription(model.description);
            this.setDistributor(model.distributor);
            this.setSupportDescription(model.supportDescription);
            this.setSupportEmail(model.supportEmail);
            this.setSupportUrl(model.supportUrl);
            this.setProductType(model.productType);
            this.setTags(model.tags);
            this.setProvisioningArtifactParameters(model.provisioningArtifactParameters);
            this.setIdempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final String getProductType() {
            return this.productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(ProductType productType) {
            this.productType(productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
        }

        public final ProvisioningArtifactProperties getProvisioningArtifactParameters() {
            return this.provisioningArtifactParameters;
        }

        @Override
        public final Builder provisioningArtifactParameters(ProvisioningArtifactProperties provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters;
            return this;
        }

        public final void setProvisioningArtifactParameters(ProvisioningArtifactProperties provisioningArtifactParameters) {
            this.provisioningArtifactParameters = provisioningArtifactParameters;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreateProductRequest build() {
            return new CreateProductRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder productType(String var1);

        public Builder productType(ProductType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder provisioningArtifactParameters(ProvisioningArtifactProperties var1);

        public Builder idempotencyToken(String var1);
    }
}

