/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;

@SdkInternalApi
public class ProductViewDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> PRODUCTVIEWSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductViewSummary").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> PRODUCTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductARN").build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").build();
    private static final ProductViewDetailMarshaller INSTANCE = new ProductViewDetailMarshaller();

    public static ProductViewDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductViewDetail productViewDetail, ProtocolMarshaller protocolMarshaller) {
        if (productViewDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)productViewDetail.productViewSummary(), PRODUCTVIEWSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)productViewDetail.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)productViewDetail.productARN(), PRODUCTARN_BINDING);
            protocolMarshaller.marshall((Object)productViewDetail.createdTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

