/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.Principal;

@SdkInternalApi
public class PrincipalMarshaller {
    private static final MarshallingInfo<String> PRINCIPALARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrincipalARN").build();
    private static final MarshallingInfo<String> PRINCIPALTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrincipalType").build();
    private static final PrincipalMarshaller INSTANCE = new PrincipalMarshaller();

    public static PrincipalMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Principal principal, ProtocolMarshaller protocolMarshaller) {
        if (principal == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)principal.principalARN(), PRINCIPALARN_BINDING);
            protocolMarshaller.marshall((Object)principal.principalType(), PRINCIPALTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

