/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;

@SdkInternalApi
public class LaunchPathSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<List> CONSTRAINTSUMMARIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConstraintSummaries").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final LaunchPathSummaryMarshaller INSTANCE = new LaunchPathSummaryMarshaller();

    public static LaunchPathSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LaunchPathSummary launchPathSummary, ProtocolMarshaller protocolMarshaller) {
        if (launchPathSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchPathSummary.id(), ID_BINDING);
            protocolMarshaller.marshall(launchPathSummary.constraintSummaries(), CONSTRAINTSUMMARIES_BINDING);
            protocolMarshaller.marshall(launchPathSummary.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)launchPathSummary.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

