/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeProductResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeProductResponse> {
    private final ProductViewSummary productViewSummary;
    private final List<ProvisioningArtifact> provisioningArtifacts;

    private DescribeProductResponse(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public List<ProvisioningArtifact> provisioningArtifacts() {
        return this.provisioningArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productViewSummary() == null ? 0 : this.productViewSummary().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifacts() == null ? 0 : this.provisioningArtifacts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductResponse)) {
            return false;
        }
        DescribeProductResponse other = (DescribeProductResponse)((Object)obj);
        if (other.productViewSummary() == null ^ this.productViewSummary() == null) {
            return false;
        }
        if (other.productViewSummary() != null && !other.productViewSummary().equals(this.productViewSummary())) {
            return false;
        }
        if (other.provisioningArtifacts() == null ^ this.provisioningArtifacts() == null) {
            return false;
        }
        return other.provisioningArtifacts() == null || other.provisioningArtifacts().equals(this.provisioningArtifacts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.productViewSummary() != null) {
            sb.append("ProductViewSummary: ").append(this.productViewSummary()).append(",");
        }
        if (this.provisioningArtifacts() != null) {
            sb.append("ProvisioningArtifacts: ").append(this.provisioningArtifacts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private List<ProvisioningArtifact> provisioningArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductResponse model) {
            this.setProductViewSummary(model.productViewSummary);
            this.setProvisioningArtifacts(model.provisioningArtifacts);
        }

        public final ProductViewSummary getProductViewSummary() {
            return this.productViewSummary;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
        }

        public final Collection<ProvisioningArtifact> getProvisioningArtifacts() {
            return this.provisioningArtifacts;
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact ... provisioningArtifacts) {
            this.provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
        }

        public DescribeProductResponse build() {
            return new DescribeProductResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeProductResponse> {
        public Builder productViewSummary(ProductViewSummary var1);

        public Builder provisioningArtifacts(Collection<ProvisioningArtifact> var1);

        public Builder provisioningArtifacts(ProvisioningArtifact ... var1);
    }
}

