/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProductSource;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsAsAdminRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SearchProductsAsAdminRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final Map<String, List<String>> filters;
    private final String sortBy;
    private final String sortOrder;
    private final String pageToken;
    private final Integer pageSize;
    private final String productSource;

    private SearchProductsAsAdminRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
        this.productSource = builder.productSource;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public Map<String, List<String>> filters() {
        return this.filters;
    }

    public String sortBy() {
        return this.sortBy;
    }

    public String sortOrder() {
        return this.sortOrder;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String productSource() {
        return this.productSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.portfolioId() == null ? 0 : this.portfolioId().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.sortBy() == null ? 0 : this.sortBy().hashCode());
        hashCode = 31 * hashCode + (this.sortOrder() == null ? 0 : this.sortOrder().hashCode());
        hashCode = 31 * hashCode + (this.pageToken() == null ? 0 : this.pageToken().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        hashCode = 31 * hashCode + (this.productSource() == null ? 0 : this.productSource().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminRequest)) {
            return false;
        }
        SearchProductsAsAdminRequest other = (SearchProductsAsAdminRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.portfolioId() == null ^ this.portfolioId() == null) {
            return false;
        }
        if (other.portfolioId() != null && !other.portfolioId().equals(this.portfolioId())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.sortBy() == null ^ this.sortBy() == null) {
            return false;
        }
        if (other.sortBy() != null && !other.sortBy().equals(this.sortBy())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        if (other.pageToken() != null && !other.pageToken().equals(this.pageToken())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        if (other.pageSize() != null && !other.pageSize().equals(this.pageSize())) {
            return false;
        }
        if (other.productSource() == null ^ this.productSource() == null) {
            return false;
        }
        return other.productSource() == null || other.productSource().equals(this.productSource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.sortBy() != null) {
            sb.append("SortBy: ").append(this.sortBy()).append(",");
        }
        if (this.sortOrder() != null) {
            sb.append("SortOrder: ").append(this.sortOrder()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.productSource() != null) {
            sb.append("ProductSource: ").append(this.productSource()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private Map<String, List<String>> filters;
        private String sortBy;
        private String sortOrder;
        private String pageToken;
        private Integer pageSize;
        private String productSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setPortfolioId(model.portfolioId);
            this.setFilters(model.filters);
            this.setSortBy(model.sortBy);
            this.setSortOrder(model.sortOrder);
            this.setPageToken(model.pageToken);
            this.setPageSize(model.pageSize);
            this.setProductSource(model.productSource);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
            return this;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final void setSortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy.toString());
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final void setSortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getProductSource() {
            return this.productSource;
        }

        @Override
        public final Builder productSource(String productSource) {
            this.productSource = productSource;
            return this;
        }

        @Override
        public final Builder productSource(ProductSource productSource) {
            this.productSource(productSource.toString());
            return this;
        }

        public final void setProductSource(String productSource) {
            this.productSource = productSource;
        }

        public final void setProductSource(ProductSource productSource) {
            this.productSource(productSource.toString());
        }

        public SearchProductsAsAdminRequest build() {
            return new SearchProductsAsAdminRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchProductsAsAdminRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ProductViewSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder productSource(String var1);

        public Builder productSource(ProductSource var1);
    }
}

