/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotificationArnsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionProductRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ProvisionProductRequest> {
    private final String acceptLanguage;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final String provisionedProductName;
    private final List<ProvisioningParameter> provisioningParameters;
    private final List<Tag> tags;
    private final List<String> notificationArns;
    private final String provisionToken;

    private ProvisionProductRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningParameters = builder.provisioningParameters;
        this.tags = builder.tags;
        this.notificationArns = builder.notificationArns;
        this.provisionToken = builder.provisionToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public List<ProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> notificationArns() {
        return this.notificationArns;
    }

    public String provisionToken() {
        return this.provisionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactId() == null ? 0 : this.provisioningArtifactId().hashCode());
        hashCode = 31 * hashCode + (this.pathId() == null ? 0 : this.pathId().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductName() == null ? 0 : this.provisionedProductName().hashCode());
        hashCode = 31 * hashCode + (this.provisioningParameters() == null ? 0 : this.provisioningParameters().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.notificationArns() == null ? 0 : this.notificationArns().hashCode());
        hashCode = 31 * hashCode + (this.provisionToken() == null ? 0 : this.provisionToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionProductRequest)) {
            return false;
        }
        ProvisionProductRequest other = (ProvisionProductRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.provisioningArtifactId() == null ^ this.provisioningArtifactId() == null) {
            return false;
        }
        if (other.provisioningArtifactId() != null && !other.provisioningArtifactId().equals(this.provisioningArtifactId())) {
            return false;
        }
        if (other.pathId() == null ^ this.pathId() == null) {
            return false;
        }
        if (other.pathId() != null && !other.pathId().equals(this.pathId())) {
            return false;
        }
        if (other.provisionedProductName() == null ^ this.provisionedProductName() == null) {
            return false;
        }
        if (other.provisionedProductName() != null && !other.provisionedProductName().equals(this.provisionedProductName())) {
            return false;
        }
        if (other.provisioningParameters() == null ^ this.provisioningParameters() == null) {
            return false;
        }
        if (other.provisioningParameters() != null && !other.provisioningParameters().equals(this.provisioningParameters())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.notificationArns() == null ^ this.notificationArns() == null) {
            return false;
        }
        if (other.notificationArns() != null && !other.notificationArns().equals(this.notificationArns())) {
            return false;
        }
        if (other.provisionToken() == null ^ this.provisionToken() == null) {
            return false;
        }
        return other.provisionToken() == null || other.provisionToken().equals(this.provisionToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.provisioningArtifactId() != null) {
            sb.append("ProvisioningArtifactId: ").append(this.provisioningArtifactId()).append(",");
        }
        if (this.pathId() != null) {
            sb.append("PathId: ").append(this.pathId()).append(",");
        }
        if (this.provisionedProductName() != null) {
            sb.append("ProvisionedProductName: ").append(this.provisionedProductName()).append(",");
        }
        if (this.provisioningParameters() != null) {
            sb.append("ProvisioningParameters: ").append(this.provisioningParameters()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.notificationArns() != null) {
            sb.append("NotificationArns: ").append(this.notificationArns()).append(",");
        }
        if (this.provisionToken() != null) {
            sb.append("ProvisionToken: ").append(this.provisionToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private String provisionedProductName;
        private List<ProvisioningParameter> provisioningParameters;
        private List<Tag> tags;
        private List<String> notificationArns;
        private String provisionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionProductRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setProductId(model.productId);
            this.setProvisioningArtifactId(model.provisioningArtifactId);
            this.setPathId(model.pathId);
            this.setProvisionedProductName(model.provisionedProductName);
            this.setProvisioningParameters(model.provisioningParameters);
            this.setTags(model.tags);
            this.setNotificationArns(model.notificationArns);
            this.setProvisionToken(model.provisionToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final Collection<ProvisioningParameter> getProvisioningParameters() {
            return this.provisioningParameters;
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
        }

        @SafeVarargs
        public final void setProvisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final Collection<String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        @SafeVarargs
        public final void setNotificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
        }

        public final String getProvisionToken() {
            return this.provisionToken;
        }

        @Override
        public final Builder provisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
            return this;
        }

        public final void setProvisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
        }

        public ProvisionProductRequest build() {
            return new ProvisionProductRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisioningParameters(Collection<ProvisioningParameter> var1);

        public Builder provisioningParameters(ProvisioningParameter ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder provisionToken(String var1);
    }
}

