/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRecordHistoryResponse> {
    private final List<RecordDetail> recordDetails;
    private final String nextPageToken;

    private ListRecordHistoryResponse(BuilderImpl builder) {
        this.recordDetails = builder.recordDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<RecordDetail> recordDetails() {
        return this.recordDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordDetails() == null ? 0 : this.recordDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordHistoryResponse)) {
            return false;
        }
        ListRecordHistoryResponse other = (ListRecordHistoryResponse)((Object)obj);
        if (other.recordDetails() == null ^ this.recordDetails() == null) {
            return false;
        }
        if (other.recordDetails() != null && !other.recordDetails().equals(this.recordDetails())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordDetails() != null) {
            sb.append("RecordDetails: ").append(this.recordDetails()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<RecordDetail> recordDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordHistoryResponse model) {
            this.setRecordDetails(model.recordDetails);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<RecordDetail> getRecordDetails() {
            return this.recordDetails;
        }

        @Override
        public final Builder recordDetails(Collection<RecordDetail> recordDetails) {
            this.recordDetails = RecordDetailsCopier.copy(recordDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordDetails(RecordDetail ... recordDetails) {
            this.recordDetails(Arrays.asList(recordDetails));
            return this;
        }

        public final void setRecordDetails(Collection<RecordDetail> recordDetails) {
            this.recordDetails = RecordDetailsCopier.copy(recordDetails);
        }

        @SafeVarargs
        public final void setRecordDetails(RecordDetail ... recordDetails) {
            this.recordDetails(Arrays.asList(recordDetails));
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListRecordHistoryResponse build() {
            return new ListRecordHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRecordHistoryResponse> {
        public Builder recordDetails(Collection<RecordDetail> var1);

        public Builder recordDetails(RecordDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

