/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLaunchPathsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListLaunchPathsResponse> {
    private final List<LaunchPathSummary> launchPathSummaries;
    private final String nextPageToken;

    private ListLaunchPathsResponse(BuilderImpl builder) {
        this.launchPathSummaries = builder.launchPathSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<LaunchPathSummary> launchPathSummaries() {
        return this.launchPathSummaries;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.launchPathSummaries() == null ? 0 : this.launchPathSummaries().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchPathsResponse)) {
            return false;
        }
        ListLaunchPathsResponse other = (ListLaunchPathsResponse)((Object)obj);
        if (other.launchPathSummaries() == null ^ this.launchPathSummaries() == null) {
            return false;
        }
        if (other.launchPathSummaries() != null && !other.launchPathSummaries().equals(this.launchPathSummaries())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.launchPathSummaries() != null) {
            sb.append("LaunchPathSummaries: ").append(this.launchPathSummaries()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LaunchPathSummary> launchPathSummaries;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchPathsResponse model) {
            this.setLaunchPathSummaries(model.launchPathSummaries);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<LaunchPathSummary> getLaunchPathSummaries() {
            return this.launchPathSummaries;
        }

        @Override
        public final Builder launchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copy(launchPathSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(LaunchPathSummary ... launchPathSummaries) {
            this.launchPathSummaries(Arrays.asList(launchPathSummaries));
            return this;
        }

        public final void setLaunchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copy(launchPathSummaries);
        }

        @SafeVarargs
        public final void setLaunchPathSummaries(LaunchPathSummary ... launchPathSummaries) {
            this.launchPathSummaries(Arrays.asList(launchPathSummaries));
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListLaunchPathsResponse build() {
            return new ListLaunchPathsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListLaunchPathsResponse> {
        public Builder launchPathSummaries(Collection<LaunchPathSummary> var1);

        public Builder launchPathSummaries(LaunchPathSummary ... var1);

        public Builder nextPageToken(String var1);
    }
}

