/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutputsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRecordResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRecordResponse> {
    private final RecordDetail recordDetail;
    private final List<RecordOutput> recordOutputs;
    private final String nextPageToken;

    private DescribeRecordResponse(BuilderImpl builder) {
        this.recordDetail = builder.recordDetail;
        this.recordOutputs = builder.recordOutputs;
        this.nextPageToken = builder.nextPageToken;
    }

    public RecordDetail recordDetail() {
        return this.recordDetail;
    }

    public List<RecordOutput> recordOutputs() {
        return this.recordOutputs;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordDetail() == null ? 0 : this.recordDetail().hashCode());
        hashCode = 31 * hashCode + (this.recordOutputs() == null ? 0 : this.recordOutputs().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecordResponse)) {
            return false;
        }
        DescribeRecordResponse other = (DescribeRecordResponse)((Object)obj);
        if (other.recordDetail() == null ^ this.recordDetail() == null) {
            return false;
        }
        if (other.recordDetail() != null && !other.recordDetail().equals(this.recordDetail())) {
            return false;
        }
        if (other.recordOutputs() == null ^ this.recordOutputs() == null) {
            return false;
        }
        if (other.recordOutputs() != null && !other.recordOutputs().equals(this.recordOutputs())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordDetail() != null) {
            sb.append("RecordDetail: ").append(this.recordDetail()).append(",");
        }
        if (this.recordOutputs() != null) {
            sb.append("RecordOutputs: ").append(this.recordOutputs()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private RecordDetail recordDetail;
        private List<RecordOutput> recordOutputs;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecordResponse model) {
            this.setRecordDetail(model.recordDetail);
            this.setRecordOutputs(model.recordOutputs);
            this.setNextPageToken(model.nextPageToken);
        }

        public final RecordDetail getRecordDetail() {
            return this.recordDetail;
        }

        @Override
        public final Builder recordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
            return this;
        }

        public final void setRecordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
        }

        public final Collection<RecordOutput> getRecordOutputs() {
            return this.recordOutputs;
        }

        @Override
        public final Builder recordOutputs(Collection<RecordOutput> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copy(recordOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(RecordOutput ... recordOutputs) {
            this.recordOutputs(Arrays.asList(recordOutputs));
            return this;
        }

        public final void setRecordOutputs(Collection<RecordOutput> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copy(recordOutputs);
        }

        @SafeVarargs
        public final void setRecordOutputs(RecordOutput ... recordOutputs) {
            this.recordOutputs(Arrays.asList(recordOutputs));
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public DescribeRecordResponse build() {
            return new DescribeRecordResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRecordResponse> {
        public Builder recordDetail(RecordDetail var1);

        public Builder recordOutputs(Collection<RecordOutput> var1);

        public Builder recordOutputs(RecordOutput ... var1);

        public Builder nextPageToken(String var1);
    }
}

