/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProvisionedProductsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchProvisionedProductsRequestMarshaller
implements Marshaller<Request<SearchProvisionedProductsRequest>, SearchProvisionedProductsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWS242ServiceCatalogService.SearchProvisionedProducts").serviceName("AWS Service Catalog").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public SearchProvisionedProductsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SearchProvisionedProductsRequest> marshall(SearchProvisionedProductsRequest searchProvisionedProductsRequest) {
        Validate.paramNotNull((Object)((Object)searchProvisionedProductsRequest), (String)"searchProvisionedProductsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)searchProvisionedProductsRequest);
            protocolMarshaller.startMarshalling();
            SearchProvisionedProductsRequestModelMarshaller.getInstance().marshall(searchProvisionedProductsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

