/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceChangeMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<String> LOGICALRESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogicalResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> PHYSICALRESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> REPLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Replacement").isBinary(false).build();
    private static final MarshallingInfo<List> SCOPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scope").isBinary(false).build();
    private static final MarshallingInfo<List> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").isBinary(false).build();
    private static final ResourceChangeMarshaller INSTANCE = new ResourceChangeMarshaller();

    private ResourceChangeMarshaller() {
    }

    public static ResourceChangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceChange resourceChange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceChange, (String)"resourceChange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceChange.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)resourceChange.logicalResourceId(), LOGICALRESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceChange.physicalResourceId(), PHYSICALRESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceChange.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceChange.replacementAsString(), REPLACEMENT_BINDING);
            protocolMarshaller.marshall(resourceChange.scopeAsStrings(), SCOPE_BINDING);
            protocolMarshaller.marshall(resourceChange.details(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

