/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceChangeDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> TARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Target").isBinary(false).build();
    private static final MarshallingInfo<String> EVALUATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Evaluation").isBinary(false).build();
    private static final MarshallingInfo<String> CAUSINGENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CausingEntity").isBinary(false).build();
    private static final ResourceChangeDetailMarshaller INSTANCE = new ResourceChangeDetailMarshaller();

    private ResourceChangeDetailMarshaller() {
    }

    public static ResourceChangeDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceChangeDetail resourceChangeDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceChangeDetail, (String)"resourceChangeDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceChangeDetail.target(), TARGET_BINDING);
            protocolMarshaller.marshall((Object)resourceChangeDetail.evaluationAsString(), EVALUATION_BINDING);
            protocolMarshaller.marshall((Object)resourceChangeDetail.causingEntity(), CAUSINGENTITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

