/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordOutputMarshaller {
    private static final MarshallingInfo<String> OUTPUTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputKey").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputValue").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final RecordOutputMarshaller INSTANCE = new RecordOutputMarshaller();

    private RecordOutputMarshaller() {
    }

    public static RecordOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordOutput recordOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recordOutput, (String)"recordOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recordOutput.outputKey(), OUTPUTKEY_BINDING);
            protocolMarshaller.marshall((Object)recordOutput.outputValue(), OUTPUTVALUE_BINDING);
            protocolMarshaller.marshall((Object)recordOutput.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

