/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedProductPlanSummaryMarshaller {
    private static final MarshallingInfo<String> PLANNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanName").isBinary(false).build();
    private static final MarshallingInfo<String> PLANID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONPRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionProductName").isBinary(false).build();
    private static final MarshallingInfo<String> PLANTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanType").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").isBinary(false).build();
    private static final ProvisionedProductPlanSummaryMarshaller INSTANCE = new ProvisionedProductPlanSummaryMarshaller();

    private ProvisionedProductPlanSummaryMarshaller() {
    }

    public static ProvisionedProductPlanSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedProductPlanSummary provisionedProductPlanSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedProductPlanSummary, (String)"provisionedProductPlanSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.planName(), PLANNAME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.planId(), PLANID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.provisionProductId(), PROVISIONPRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.provisionProductName(), PROVISIONPRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.planTypeAsString(), PLANTYPE_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanSummary.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

