/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedProductPlanDetailsMarshaller {
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();
    private static final MarshallingInfo<String> PATHID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PathId").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PLANNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanName").isBinary(false).build();
    private static final MarshallingInfo<String> PLANID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONPRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionProductName").isBinary(false).build();
    private static final MarshallingInfo<String> PLANTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanType").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> UPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTime").isBinary(false).build();
    private static final MarshallingInfo<List> NOTIFICATIONARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationArns").isBinary(false).build();
    private static final MarshallingInfo<List> PROVISIONINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningParameters").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final ProvisionedProductPlanDetailsMarshaller INSTANCE = new ProvisionedProductPlanDetailsMarshaller();

    private ProvisionedProductPlanDetailsMarshaller() {
    }

    public static ProvisionedProductPlanDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedProductPlanDetails provisionedProductPlanDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedProductPlanDetails, (String)"provisionedProductPlanDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.pathId(), PATHID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.planName(), PLANNAME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.planId(), PLANID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.provisionProductId(), PROVISIONPRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.provisionProductName(), PROVISIONPRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.planTypeAsString(), PLANTYPE_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.updatedTime(), UPDATEDTIME_BINDING);
            protocolMarshaller.marshall(provisionedProductPlanDetails.notificationArns(), NOTIFICATIONARNS_BINDING);
            protocolMarshaller.marshall(provisionedProductPlanDetails.provisioningParameters(), PROVISIONINGPARAMETERS_BINDING);
            protocolMarshaller.marshall(provisionedProductPlanDetails.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductPlanDetails.statusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

