/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.EvaluationType;
import software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition;
import software.amazon.awssdk.services.servicecatalog.transform.ResourceChangeDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceChangeDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceChangeDetail> {
    private final ResourceTargetDefinition target;
    private final String evaluation;
    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.causingEntity = builder.causingEntity;
    }

    public ResourceTargetDefinition target() {
        return this.target;
    }

    public EvaluationType evaluation() {
        return EvaluationType.fromValue(this.evaluation);
    }

    public String evaluationAsString() {
        return this.evaluation;
    }

    public String causingEntity() {
        return this.causingEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.causingEntity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.evaluationAsString(), other.evaluationAsString()) && Objects.equals(this.causingEntity(), other.causingEntity());
    }

    public String toString() {
        return ToString.builder((String)"ResourceChangeDetail").add("Target", (Object)this.target()).add("Evaluation", (Object)this.evaluationAsString()).add("CausingEntity", (Object)this.causingEntity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Evaluation": {
                return Optional.ofNullable(clazz.cast(this.evaluationAsString()));
            }
            case "CausingEntity": {
                return Optional.ofNullable(clazz.cast(this.causingEntity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceChangeDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceTargetDefinition target;
        private String evaluation;
        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            this.target(model.target);
            this.evaluation(model.evaluation);
            this.causingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getEvaluation() {
            return this.evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final String getCausingEntity() {
            return this.causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChangeDetail> {
        public Builder target(ResourceTargetDefinition var1);

        default public Builder target(Consumer<ResourceTargetDefinition.Builder> target) {
            return this.target((ResourceTargetDefinition)((ResourceTargetDefinition.Builder)ResourceTargetDefinition.builder().applyMutation(target)).build());
        }

        public Builder evaluation(String var1);

        public Builder evaluation(EvaluationType var1);

        public Builder causingEntity(String var1);
    }
}

