/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ChangeAction;
import software.amazon.awssdk.services.servicecatalog.model.Replacement;
import software.amazon.awssdk.services.servicecatalog.model.ResourceAttribute;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetail;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangeDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ScopeCopier;
import software.amazon.awssdk.services.servicecatalog.transform.ResourceChangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceChange
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceChange> {
    private final String action;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final String replacement;
    private final List<String> scope;
    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Replacement replacement() {
        return Replacement.fromValue(this.replacement);
    }

    public String replacementAsString() {
        return this.replacement;
    }

    public List<ResourceAttribute> scope() {
        return TypeConverter.convert(this.scope, ResourceAttribute::fromValue);
    }

    public List<String> scopeAsStrings() {
        return this.scope;
    }

    public List<ResourceChangeDetail> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.replacementAsString(), other.replacementAsString()) && Objects.equals(this.scopeAsStrings(), other.scopeAsStrings()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"ResourceChange").add("Action", (Object)this.actionAsString()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Replacement", (Object)this.replacementAsString()).add("Scope", this.scopeAsStrings()).add("Details", this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Replacement": {
                return Optional.ofNullable(clazz.cast(this.replacementAsString()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsStrings()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private String replacement;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceChangeDetail> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            this.action(model.action);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.replacement(model.replacement);
            this.scopeWithStrings(model.scope);
            this.details(model.details);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacement() {
            return this.replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final Collection<String> getScope() {
            return this.scope;
        }

        @Override
        public final Builder scopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopeWithStrings(String ... scope) {
            this.scopeWithStrings(Arrays.asList(scope));
            return this;
        }

        @Override
        public final Builder scope(Collection<ResourceAttribute> scope) {
            this.scope = ScopeCopier.copyEnumToString(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        public final Collection<ResourceChangeDetail.Builder> getDetails() {
            return this.details != null ? (Collection)this.details.stream().map(ResourceChangeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<ResourceChangeDetail.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (ResourceChangeDetail)((ResourceChangeDetail.Builder)ResourceChangeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        public ResourceChange build() {
            return new ResourceChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChange> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder replacement(String var1);

        public Builder replacement(Replacement var1);

        public Builder scopeWithStrings(Collection<String> var1);

        public Builder scopeWithStrings(String ... var1);

        public Builder scope(Collection<ResourceAttribute> var1);

        public Builder scope(ResourceAttribute ... var1);

        public Builder details(Collection<ResourceChangeDetail> var1);

        public Builder details(ResourceChangeDetail ... var1);

        public Builder details(Consumer<ResourceChangeDetail.Builder> ... var1);
    }
}

