/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConstraintsForPortfolioRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListConstraintsForPortfolioRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String productId;
    private final Integer pageSize;
    private final String pageToken;

    private ListConstraintsForPortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.productId = builder.productId;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String productId() {
        return this.productId;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConstraintsForPortfolioRequest)) {
            return false;
        }
        ListConstraintsForPortfolioRequest other = (ListConstraintsForPortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConstraintsForPortfolioRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).add("ProductId", (Object)this.productId()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String productId;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConstraintsForPortfolioRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.productId(model.productId);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConstraintsForPortfolioRequest build() {
            return new ListConstraintsForPortfolioRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, ListConstraintsForPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder productId(String var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

