/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstruction;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstructionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisioningParametersResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
    private final List<ProvisioningArtifactParameter> provisioningArtifactParameters;
    private final List<ConstraintSummary> constraintSummaries;
    private final List<UsageInstruction> usageInstructions;
    private final List<TagOptionSummary> tagOptions;

    private DescribeProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.constraintSummaries = builder.constraintSummaries;
        this.usageInstructions = builder.usageInstructions;
        this.tagOptions = builder.tagOptions;
    }

    public List<ProvisioningArtifactParameter> provisioningArtifactParameters() {
        return this.provisioningArtifactParameters;
    }

    public List<ConstraintSummary> constraintSummaries() {
        return this.constraintSummaries;
    }

    public List<UsageInstruction> usageInstructions() {
        return this.usageInstructions;
    }

    public List<TagOptionSummary> tagOptions() {
        return this.tagOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersResponse)) {
            return false;
        }
        DescribeProvisioningParametersResponse other = (DescribeProvisioningParametersResponse)((Object)obj);
        return Objects.equals(this.provisioningArtifactParameters(), other.provisioningArtifactParameters()) && Objects.equals(this.constraintSummaries(), other.constraintSummaries()) && Objects.equals(this.usageInstructions(), other.usageInstructions()) && Objects.equals(this.tagOptions(), other.tagOptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProvisioningParametersResponse").add("ProvisioningArtifactParameters", this.provisioningArtifactParameters()).add("ConstraintSummaries", this.constraintSummaries()).add("UsageInstructions", this.usageInstructions()).add("TagOptions", this.tagOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactParameters()));
            }
            case "ConstraintSummaries": {
                return Optional.ofNullable(clazz.cast(this.constraintSummaries()));
            }
            case "UsageInstructions": {
                return Optional.ofNullable(clazz.cast(this.usageInstructions()));
            }
            case "TagOptions": {
                return Optional.ofNullable(clazz.cast(this.tagOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactParameter> provisioningArtifactParameters = DefaultSdkAutoConstructList.getInstance();
        private List<ConstraintSummary> constraintSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<UsageInstruction> usageInstructions = DefaultSdkAutoConstructList.getInstance();
        private List<TagOptionSummary> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersResponse model) {
            super(model);
            this.provisioningArtifactParameters(model.provisioningArtifactParameters);
            this.constraintSummaries(model.constraintSummaries);
            this.usageInstructions(model.usageInstructions);
            this.tagOptions(model.tagOptions);
        }

        public final Collection<ProvisioningArtifactParameter.Builder> getProvisioningArtifactParameters() {
            return this.provisioningArtifactParameters != null ? (Collection)this.provisioningArtifactParameters.stream().map(ProvisioningArtifactParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... provisioningArtifactParameters) {
            this.provisioningArtifactParameters(Arrays.asList(provisioningArtifactParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder> ... provisioningArtifactParameters) {
            this.provisioningArtifactParameters(Stream.of(provisioningArtifactParameters).map(c -> (ProvisioningArtifactParameter)((ProvisioningArtifactParameter.Builder)ProvisioningArtifactParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactParameters(Collection<ProvisioningArtifactParameter.BuilderImpl> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copyFromBuilder(provisioningArtifactParameters);
        }

        public final Collection<ConstraintSummary.Builder> getConstraintSummaries() {
            return this.constraintSummaries != null ? (Collection)this.constraintSummaries.stream().map(ConstraintSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary ... constraintSummaries) {
            this.constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(Consumer<ConstraintSummary.Builder> ... constraintSummaries) {
            this.constraintSummaries(Stream.of(constraintSummaries).map(c -> (ConstraintSummary)((ConstraintSummary.Builder)ConstraintSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        public final Collection<UsageInstruction.Builder> getUsageInstructions() {
            return this.usageInstructions != null ? (Collection)this.usageInstructions.stream().map(UsageInstruction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(UsageInstruction ... usageInstructions) {
            this.usageInstructions(Arrays.asList(usageInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(Consumer<UsageInstruction.Builder> ... usageInstructions) {
            this.usageInstructions(Stream.of(usageInstructions).map(c -> (UsageInstruction)((UsageInstruction.Builder)UsageInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsageInstructions(Collection<UsageInstruction.BuilderImpl> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copyFromBuilder(usageInstructions);
        }

        public final Collection<TagOptionSummary.Builder> getTagOptions() {
            return this.tagOptions != null ? (Collection)this.tagOptions.stream().map(TagOptionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionSummary> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionSummary ... tagOptions) {
            this.tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionSummary.Builder> ... tagOptions) {
            this.tagOptions(Stream.of(tagOptions).map(c -> (TagOptionSummary)((TagOptionSummary.Builder)TagOptionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionSummary.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copyFromBuilder(tagOptions);
        }

        @Override
        public DescribeProvisioningParametersResponse build() {
            return new DescribeProvisioningParametersResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
        public Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> var1);

        public Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... var1);

        public Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder> ... var1);

        public Builder constraintSummaries(Collection<ConstraintSummary> var1);

        public Builder constraintSummaries(ConstraintSummary ... var1);

        public Builder constraintSummaries(Consumer<ConstraintSummary.Builder> ... var1);

        public Builder usageInstructions(Collection<UsageInstruction> var1);

        public Builder usageInstructions(UsageInstruction ... var1);

        public Builder usageInstructions(Consumer<UsageInstruction.Builder> ... var1);

        public Builder tagOptions(Collection<TagOptionSummary> var1);

        public Builder tagOptions(TagOptionSummary ... var1);

        public Builder tagOptions(Consumer<TagOptionSummary.Builder> ... var1);
    }
}

