/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChange;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChangesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisionedProductPlanResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProvisionedProductPlanResponse> {
    private final ProvisionedProductPlanDetails provisionedProductPlanDetails;
    private final List<ResourceChange> resourceChanges;
    private final String nextPageToken;

    private DescribeProvisionedProductPlanResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductPlanDetails = builder.provisionedProductPlanDetails;
        this.resourceChanges = builder.resourceChanges;
        this.nextPageToken = builder.nextPageToken;
    }

    public ProvisionedProductPlanDetails provisionedProductPlanDetails() {
        return this.provisionedProductPlanDetails;
    }

    public List<ResourceChange> resourceChanges() {
        return this.resourceChanges;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductPlanDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceChanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisionedProductPlanResponse)) {
            return false;
        }
        DescribeProvisionedProductPlanResponse other = (DescribeProvisionedProductPlanResponse)((Object)obj);
        return Objects.equals(this.provisionedProductPlanDetails(), other.provisionedProductPlanDetails()) && Objects.equals(this.resourceChanges(), other.resourceChanges()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProvisionedProductPlanResponse").add("ProvisionedProductPlanDetails", (Object)this.provisionedProductPlanDetails()).add("ResourceChanges", this.resourceChanges()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductPlanDetails": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductPlanDetails()));
            }
            case "ResourceChanges": {
                return Optional.ofNullable(clazz.cast(this.resourceChanges()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProvisionedProductPlanDetails provisionedProductPlanDetails;
        private List<ResourceChange> resourceChanges = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisionedProductPlanResponse model) {
            super(model);
            this.provisionedProductPlanDetails(model.provisionedProductPlanDetails);
            this.resourceChanges(model.resourceChanges);
            this.nextPageToken(model.nextPageToken);
        }

        public final ProvisionedProductPlanDetails.Builder getProvisionedProductPlanDetails() {
            return this.provisionedProductPlanDetails != null ? this.provisionedProductPlanDetails.toBuilder() : null;
        }

        @Override
        public final Builder provisionedProductPlanDetails(ProvisionedProductPlanDetails provisionedProductPlanDetails) {
            this.provisionedProductPlanDetails = provisionedProductPlanDetails;
            return this;
        }

        public final void setProvisionedProductPlanDetails(ProvisionedProductPlanDetails.BuilderImpl provisionedProductPlanDetails) {
            this.provisionedProductPlanDetails = provisionedProductPlanDetails != null ? provisionedProductPlanDetails.build() : null;
        }

        public final Collection<ResourceChange.Builder> getResourceChanges() {
            return this.resourceChanges != null ? (Collection)this.resourceChanges.stream().map(ResourceChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceChanges(Collection<ResourceChange> resourceChanges) {
            this.resourceChanges = ResourceChangesCopier.copy(resourceChanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceChanges(ResourceChange ... resourceChanges) {
            this.resourceChanges(Arrays.asList(resourceChanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceChanges(Consumer<ResourceChange.Builder> ... resourceChanges) {
            this.resourceChanges(Stream.of(resourceChanges).map(c -> (ResourceChange)((ResourceChange.Builder)ResourceChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceChanges(Collection<ResourceChange.BuilderImpl> resourceChanges) {
            this.resourceChanges = ResourceChangesCopier.copyFromBuilder(resourceChanges);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public DescribeProvisionedProductPlanResponse build() {
            return new DescribeProvisionedProductPlanResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribeProvisionedProductPlanResponse> {
        public Builder provisionedProductPlanDetails(ProvisionedProductPlanDetails var1);

        default public Builder provisionedProductPlanDetails(Consumer<ProvisionedProductPlanDetails.Builder> provisionedProductPlanDetails) {
            return this.provisionedProductPlanDetails((ProvisionedProductPlanDetails)((ProvisionedProductPlanDetails.Builder)ProvisionedProductPlanDetails.builder().applyMutation(provisionedProductPlanDetails)).build());
        }

        public Builder resourceChanges(Collection<ResourceChange> var1);

        public Builder resourceChanges(ResourceChange ... var1);

        public Builder resourceChanges(Consumer<ResourceChange.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

