/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProvisionedProductPlanRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DeleteProvisionedProductPlanRequest> {
    private final String acceptLanguage;
    private final String planId;
    private final Boolean ignoreErrors;

    private DeleteProvisionedProductPlanRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.planId = builder.planId;
        this.ignoreErrors = builder.ignoreErrors;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String planId() {
        return this.planId;
    }

    public Boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.planId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProvisionedProductPlanRequest)) {
            return false;
        }
        DeleteProvisionedProductPlanRequest other = (DeleteProvisionedProductPlanRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.planId(), other.planId()) && Objects.equals(this.ignoreErrors(), other.ignoreErrors());
    }

    public String toString() {
        return ToString.builder((String)"DeleteProvisionedProductPlanRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PlanId", (Object)this.planId()).add("IgnoreErrors", (Object)this.ignoreErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PlanId": {
                return Optional.ofNullable(clazz.cast(this.planId()));
            }
            case "IgnoreErrors": {
                return Optional.ofNullable(clazz.cast(this.ignoreErrors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String planId;
        private Boolean ignoreErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProvisionedProductPlanRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.planId(model.planId);
            this.ignoreErrors(model.ignoreErrors);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPlanId() {
            return this.planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        public final Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public final Builder ignoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public final void setIgnoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProvisionedProductPlanRequest build() {
            return new DeleteProvisionedProductPlanRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, DeleteProvisionedProductPlanRequest> {
        public Builder acceptLanguage(String var1);

        public Builder planId(String var1);

        public Builder ignoreErrors(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

