/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.CopyOption;
import software.amazon.awssdk.services.servicecatalog.model.CopyOptionsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SourceProvisioningArtifactPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, CopyProductRequest> {
    private final String acceptLanguage;
    private final String sourceProductArn;
    private final String targetProductId;
    private final String targetProductName;
    private final List<Map<String, String>> sourceProvisioningArtifactIdentifiers;
    private final List<String> copyOptions;
    private final String idempotencyToken;

    private CopyProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.sourceProductArn = builder.sourceProductArn;
        this.targetProductId = builder.targetProductId;
        this.targetProductName = builder.targetProductName;
        this.sourceProvisioningArtifactIdentifiers = builder.sourceProvisioningArtifactIdentifiers;
        this.copyOptions = builder.copyOptions;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String sourceProductArn() {
        return this.sourceProductArn;
    }

    public String targetProductId() {
        return this.targetProductId;
    }

    public String targetProductName() {
        return this.targetProductName;
    }

    public List<Map<String, String>> sourceProvisioningArtifactIdentifiers() {
        return this.sourceProvisioningArtifactIdentifiers;
    }

    public List<CopyOption> copyOptions() {
        return TypeConverter.convert(this.copyOptions, CopyOption::fromValue);
    }

    public List<String> copyOptionsAsStrings() {
        return this.copyOptions;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProductArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProvisioningArtifactIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProductRequest)) {
            return false;
        }
        CopyProductRequest other = (CopyProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.sourceProductArn(), other.sourceProductArn()) && Objects.equals(this.targetProductId(), other.targetProductId()) && Objects.equals(this.targetProductName(), other.targetProductName()) && Objects.equals(this.sourceProvisioningArtifactIdentifiers(), other.sourceProvisioningArtifactIdentifiers()) && Objects.equals(this.copyOptionsAsStrings(), other.copyOptionsAsStrings()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"CopyProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("SourceProductArn", (Object)this.sourceProductArn()).add("TargetProductId", (Object)this.targetProductId()).add("TargetProductName", (Object)this.targetProductName()).add("SourceProvisioningArtifactIdentifiers", this.sourceProvisioningArtifactIdentifiers()).add("CopyOptions", this.copyOptionsAsStrings()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "SourceProductArn": {
                return Optional.ofNullable(clazz.cast(this.sourceProductArn()));
            }
            case "TargetProductId": {
                return Optional.ofNullable(clazz.cast(this.targetProductId()));
            }
            case "TargetProductName": {
                return Optional.ofNullable(clazz.cast(this.targetProductName()));
            }
            case "SourceProvisioningArtifactIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.sourceProvisioningArtifactIdentifiers()));
            }
            case "CopyOptions": {
                return Optional.ofNullable(clazz.cast(this.copyOptionsAsStrings()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String sourceProductArn;
        private String targetProductId;
        private String targetProductName;
        private List<Map<String, String>> sourceProvisioningArtifactIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> copyOptions = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.sourceProductArn(model.sourceProductArn);
            this.targetProductId(model.targetProductId);
            this.targetProductName(model.targetProductName);
            this.sourceProvisioningArtifactIdentifiers(model.sourceProvisioningArtifactIdentifiers);
            this.copyOptionsWithStrings(model.copyOptions);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getSourceProductArn() {
            return this.sourceProductArn;
        }

        @Override
        public final Builder sourceProductArn(String sourceProductArn) {
            this.sourceProductArn = sourceProductArn;
            return this;
        }

        public final void setSourceProductArn(String sourceProductArn) {
            this.sourceProductArn = sourceProductArn;
        }

        public final String getTargetProductId() {
            return this.targetProductId;
        }

        @Override
        public final Builder targetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
            return this;
        }

        public final void setTargetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
        }

        public final String getTargetProductName() {
            return this.targetProductName;
        }

        @Override
        public final Builder targetProductName(String targetProductName) {
            this.targetProductName = targetProductName;
            return this;
        }

        public final void setTargetProductName(String targetProductName) {
            this.targetProductName = targetProductName;
        }

        public final Collection<Map<String, String>> getSourceProvisioningArtifactIdentifiers() {
            return this.sourceProvisioningArtifactIdentifiers;
        }

        @Override
        public final Builder sourceProvisioningArtifactIdentifiers(Collection<Map<String, String>> sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactPropertiesCopier.copy(sourceProvisioningArtifactIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceProvisioningArtifactIdentifiers(Map<String, String> ... sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers(Arrays.asList(sourceProvisioningArtifactIdentifiers));
            return this;
        }

        public final void setSourceProvisioningArtifactIdentifiers(Collection<Map<String, String>> sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactPropertiesCopier.copy(sourceProvisioningArtifactIdentifiers);
        }

        public final Collection<String> getCopyOptions() {
            return this.copyOptions;
        }

        @Override
        public final Builder copyOptionsWithStrings(Collection<String> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copy(copyOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyOptionsWithStrings(String ... copyOptions) {
            this.copyOptionsWithStrings(Arrays.asList(copyOptions));
            return this;
        }

        @Override
        public final Builder copyOptions(Collection<CopyOption> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copyEnumToString(copyOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyOptions(CopyOption ... copyOptions) {
            this.copyOptions(Arrays.asList(copyOptions));
            return this;
        }

        public final void setCopyOptions(Collection<String> copyOptions) {
            this.copyOptions = CopyOptionsCopier.copy(copyOptions);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyProductRequest build() {
            return new CopyProductRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, CopyProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder sourceProductArn(String var1);

        public Builder targetProductId(String var1);

        public Builder targetProductName(String var1);

        public Builder sourceProvisioningArtifactIdentifiers(Collection<Map<String, String>> var1);

        public Builder sourceProvisioningArtifactIdentifiers(Map<String, String> ... var1);

        public Builder copyOptionsWithStrings(Collection<String> var1);

        public Builder copyOptionsWithStrings(String ... var1);

        public Builder copyOptions(Collection<CopyOption> var1);

        public Builder copyOptions(CopyOption ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

