/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchProductsAsAdminRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<String> PORTFOLIOID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortfolioId").isBinary(false).build();
    private static final MarshallingInfo<Map> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<String> SORTBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortBy").isBinary(false).build();
    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductSource").isBinary(false).build();
    private static final SearchProductsAsAdminRequestModelMarshaller INSTANCE = new SearchProductsAsAdminRequestModelMarshaller();

    private SearchProductsAsAdminRequestModelMarshaller() {
    }

    public static SearchProductsAsAdminRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchProductsAsAdminRequest searchProductsAsAdminRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchProductsAsAdminRequest), (String)"searchProductsAsAdminRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.portfolioId(), PORTFOLIOID_BINDING);
            protocolMarshaller.marshall(searchProductsAsAdminRequest.filtersAsStrings(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.sortByAsString(), SORTBY_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.sortOrderAsString(), SORTORDER_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.pageToken(), PAGETOKEN_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)searchProductsAsAdminRequest.productSourceAsString(), PRODUCTSOURCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

