/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordTag;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordTagMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final RecordTagMarshaller INSTANCE = new RecordTagMarshaller();

    private RecordTagMarshaller() {
    }

    public static RecordTagMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordTag recordTag, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recordTag, (String)"recordTag");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recordTag.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)recordTag.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

