/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProductViewAggregationValueMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Integer> APPROXIMATECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApproximateCount").isBinary(false).build();
    private static final ProductViewAggregationValueMarshaller INSTANCE = new ProductViewAggregationValueMarshaller();

    private ProductViewAggregationValueMarshaller() {
    }

    public static ProductViewAggregationValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductViewAggregationValue productViewAggregationValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)productViewAggregationValue, (String)"productViewAggregationValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)productViewAggregationValue.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)productViewAggregationValue.approximateCount(), APPROXIMATECOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

