/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;

public class ListPortfoliosPublisher
implements SdkPublisher<ListPortfoliosResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListPortfoliosRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortfoliosPublisher(ServiceCatalogAsyncClient client, ListPortfoliosRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortfoliosPublisher(ServiceCatalogAsyncClient client, ListPortfoliosRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortfoliosResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortfoliosResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListPortfoliosPublisher resume(ListPortfoliosResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPortfoliosPublisher(this.client, (ListPortfoliosRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPortfoliosPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPortfoliosResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPortfoliosResponseFetcher
    implements AsyncPageFetcher<ListPortfoliosResponse> {
        private ListPortfoliosResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosResponse previousPage) {
            return previousPage.nextPageToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextPageToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextPageToken());
        }

        public CompletableFuture<ListPortfoliosResponse> nextPage(ListPortfoliosResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosPublisher.this.client.listPortfolios(ListPortfoliosPublisher.this.firstRequest);
            }
            return ListPortfoliosPublisher.this.client.listPortfolios((ListPortfoliosRequest)((Object)ListPortfoliosPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

