/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;

public class ListPortfoliosIterable
implements SdkIterable<ListPortfoliosResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortfoliosIterable(ServiceCatalogClient client, ListPortfoliosRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfoliosResponseFetcher();
    }

    public Iterator<ListPortfoliosResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListPortfoliosIterable resume(ListPortfoliosResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPortfoliosIterable(this.client, (ListPortfoliosRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPortfoliosIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPortfoliosResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPortfoliosResponseFetcher
    implements SyncPageFetcher<ListPortfoliosResponse> {
        private ListPortfoliosResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosResponse previousPage) {
            return previousPage.nextPageToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextPageToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextPageToken());
        }

        public ListPortfoliosResponse nextPage(ListPortfoliosResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosIterable.this.client.listPortfolios(ListPortfoliosIterable.this.firstRequest);
            }
            return ListPortfoliosIterable.this.client.listPortfolios((ListPortfoliosRequest)((Object)ListPortfoliosIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

