/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagOptionsRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListTagOptionsRequest> {
    private final ListTagOptionsFilters filters;
    private final Integer pageSize;
    private final String pageToken;

    private ListTagOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public ListTagOptionsFilters filters() {
        return this.filters;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagOptionsRequest)) {
            return false;
        }
        ListTagOptionsRequest other = (ListTagOptionsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTagOptionsRequest").add("Filters", (Object)this.filters()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private ListTagOptionsFilters filters;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagOptionsRequest model) {
            super(model);
            this.filters(model.filters);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final ListTagOptionsFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(ListTagOptionsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(ListTagOptionsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagOptionsRequest build() {
            return new ListTagOptionsRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, ListTagOptionsRequest> {
        public Builder filters(ListTagOptionsFilters var1);

        default public Builder filters(Consumer<ListTagOptionsFilters.Builder> filters) {
            return this.filters((ListTagOptionsFilters)((ListTagOptionsFilters.Builder)ListTagOptionsFilters.builder().applyMutation(filters)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

