/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductViewResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProductViewResponse> {
    private final ProductViewSummary productViewSummary;
    private final List<ProvisioningArtifact> provisioningArtifacts;

    private DescribeProductViewResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public List<ProvisioningArtifact> provisioningArtifacts() {
        return this.provisioningArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifacts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductViewResponse)) {
            return false;
        }
        DescribeProductViewResponse other = (DescribeProductViewResponse)((Object)obj);
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.provisioningArtifacts(), other.provisioningArtifacts());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProductViewResponse").add("ProductViewSummary", (Object)this.productViewSummary()).add("ProvisioningArtifacts", this.provisioningArtifacts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "ProvisioningArtifacts": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifacts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private List<ProvisioningArtifact> provisioningArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductViewResponse model) {
            super(model);
            this.productViewSummary(model.productViewSummary);
            this.provisioningArtifacts(model.provisioningArtifacts);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final Collection<ProvisioningArtifact.Builder> getProvisioningArtifacts() {
            return this.provisioningArtifacts != null ? (Collection)this.provisioningArtifacts.stream().map(ProvisioningArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact ... provisioningArtifacts) {
            this.provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... provisioningArtifacts) {
            this.provisioningArtifacts(Stream.of(provisioningArtifacts).map(c -> (ProvisioningArtifact)((ProvisioningArtifact.Builder)ProvisioningArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact.BuilderImpl> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copyFromBuilder(provisioningArtifacts);
        }

        @Override
        public DescribeProductViewResponse build() {
            return new DescribeProductViewResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribeProductViewResponse> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder provisioningArtifacts(Collection<ProvisioningArtifact> var1);

        public Builder provisioningArtifacts(ProvisioningArtifact ... var1);

        public Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... var1);
    }
}

