/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListTagOptionsRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final ListTagOptionsRequestModelMarshaller INSTANCE = new ListTagOptionsRequestModelMarshaller();

    private ListTagOptionsRequestModelMarshaller() {
    }

    public static ListTagOptionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListTagOptionsRequest listTagOptionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listTagOptionsRequest), (String)"listTagOptionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listTagOptionsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)listTagOptionsRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)listTagOptionsRequest.pageToken(), PAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

