/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioShareRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreatePortfolioShareRequestMarshaller
implements Marshaller<Request<CreatePortfolioShareRequest>, CreatePortfolioShareRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWS242ServiceCatalogService.CreatePortfolioShare").serviceName("AWS Service Catalog").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreatePortfolioShareRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreatePortfolioShareRequest> marshall(CreatePortfolioShareRequest createPortfolioShareRequest) {
        Validate.paramNotNull((Object)((Object)createPortfolioShareRequest), (String)"createPortfolioShareRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createPortfolioShareRequest);
            protocolMarshaller.startMarshalling();
            CreatePortfolioShareRequestModelMarshaller.getInstance().marshall(createPortfolioShareRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

