/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductStatus;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisionedProductDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedProductDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisionedProductDetail> {
    private final String name;
    private final String arn;
    private final String type;
    private final String id;
    private final String status;
    private final String statusMessage;
    private final Instant createdTime;
    private final String idempotencyToken;
    private final String lastRecordId;

    private ProvisionedProductDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.id = builder.id;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.idempotencyToken = builder.idempotencyToken;
        this.lastRecordId = builder.lastRecordId;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public ProvisionedProductStatus status() {
        return ProvisionedProductStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public String lastRecordId() {
        return this.lastRecordId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecordId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductDetail)) {
            return false;
        }
        ProvisionedProductDetail other = (ProvisionedProductDetail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.lastRecordId(), other.lastRecordId());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionedProductDetail").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedTime", (Object)this.createdTime()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("LastRecordId", (Object)this.lastRecordId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "IdempotencyToken": {
                return Optional.of(clazz.cast(this.idempotencyToken()));
            }
            case "LastRecordId": {
                return Optional.of(clazz.cast(this.lastRecordId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedProductDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String type;
        private String id;
        private String status;
        private String statusMessage;
        private Instant createdTime;
        private String idempotencyToken;
        private String lastRecordId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductDetail model) {
            this.name(model.name);
            this.arn(model.arn);
            this.type(model.type);
            this.id(model.id);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdTime(model.createdTime);
            this.idempotencyToken(model.idempotencyToken);
            this.lastRecordId(model.lastRecordId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedProductStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final String getLastRecordId() {
            return this.lastRecordId;
        }

        @Override
        public final Builder lastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
            return this;
        }

        public final void setLastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
        }

        public ProvisionedProductDetail build() {
            return new ProvisionedProductDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedProductDetail> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ProvisionedProductStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdTime(Instant var1);

        public Builder idempotencyToken(String var1);

        public Builder lastRecordId(String var1);
    }
}

