/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.PrincipalType;
import software.amazon.awssdk.services.servicecatalog.transform.PrincipalMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Principal
implements StructuredPojo,
ToCopyableBuilder<Builder, Principal> {
    private final String principalARN;
    private final String principalType;

    private Principal(BuilderImpl builder) {
        this.principalARN = builder.principalARN;
        this.principalType = builder.principalType;
    }

    public String principalARN() {
        return this.principalARN;
    }

    public PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public String principalTypeAsString() {
        return this.principalType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        return Objects.equals(this.principalARN(), other.principalARN()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Principal").add("PrincipalARN", (Object)this.principalARN()).add("PrincipalType", (Object)this.principalTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalARN": {
                return Optional.of(clazz.cast(this.principalARN()));
            }
            case "PrincipalType": {
                return Optional.of(clazz.cast(this.principalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalARN;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            this.principalARN(model.principalARN);
            this.principalType(model.principalType);
        }

        public final String getPrincipalARN() {
            return this.principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType.toString());
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        public Principal build() {
            return new Principal(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Principal> {
        public Builder principalARN(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);
    }
}

