/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordHistoryResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListRecordHistoryResponse> {
    private final List<RecordDetail> recordDetails;
    private final String nextPageToken;

    private ListRecordHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.recordDetails = builder.recordDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<RecordDetail> recordDetails() {
        return this.recordDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordHistoryResponse)) {
            return false;
        }
        ListRecordHistoryResponse other = (ListRecordHistoryResponse)((Object)obj);
        return Objects.equals(this.recordDetails(), other.recordDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRecordHistoryResponse").add("RecordDetails", this.recordDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordDetails": {
                return Optional.of(clazz.cast(this.recordDetails()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<RecordDetail> recordDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordHistoryResponse model) {
            super(model);
            this.recordDetails(model.recordDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<RecordDetail.Builder> getRecordDetails() {
            return this.recordDetails != null ? (Collection)this.recordDetails.stream().map(RecordDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordDetails(Collection<RecordDetail> recordDetails) {
            this.recordDetails = RecordDetailsCopier.copy(recordDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordDetails(RecordDetail ... recordDetails) {
            this.recordDetails(Arrays.asList(recordDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordDetails(Consumer<RecordDetail.Builder> ... recordDetails) {
            this.recordDetails(Stream.of(recordDetails).map(c -> (RecordDetail)((RecordDetail.Builder)RecordDetail.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordDetails(Collection<RecordDetail.BuilderImpl> recordDetails) {
            this.recordDetails = RecordDetailsCopier.copyFromBuilder(recordDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListRecordHistoryResponse build() {
            return new ListRecordHistoryResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ListRecordHistoryResponse> {
        public Builder recordDetails(Collection<RecordDetail> var1);

        public Builder recordDetails(RecordDetail ... var1);

        public Builder recordDetails(Consumer<RecordDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

