/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribePortfolioResponse> {
    private final PortfolioDetail portfolioDetail;
    private final List<Tag> tags;
    private final List<TagOptionDetail> tagOptions;

    private DescribePortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
        this.tagOptions = builder.tagOptions;
    }

    public PortfolioDetail portfolioDetail() {
        return this.portfolioDetail;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<TagOptionDetail> tagOptions() {
        return this.tagOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioResponse)) {
            return false;
        }
        DescribePortfolioResponse other = (DescribePortfolioResponse)((Object)obj);
        return Objects.equals(this.portfolioDetail(), other.portfolioDetail()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tagOptions(), other.tagOptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribePortfolioResponse").add("PortfolioDetail", (Object)this.portfolioDetail()).add("Tags", this.tags()).add("TagOptions", this.tagOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetail": {
                return Optional.of(clazz.cast(this.portfolioDetail()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "TagOptions": {
                return Optional.of(clazz.cast(this.tagOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private PortfolioDetail portfolioDetail;
        private List<Tag> tags;
        private List<TagOptionDetail> tagOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioResponse model) {
            super(model);
            this.portfolioDetail(model.portfolioDetail);
            this.tags(model.tags);
            this.tagOptions(model.tagOptions);
        }

        public final PortfolioDetail.Builder getPortfolioDetail() {
            return this.portfolioDetail != null ? this.portfolioDetail.toBuilder() : null;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final void setPortfolioDetail(PortfolioDetail.BuilderImpl portfolioDetail) {
            this.portfolioDetail = portfolioDetail != null ? portfolioDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<TagOptionDetail.Builder> getTagOptions() {
            return this.tagOptions != null ? (Collection)this.tagOptions.stream().map(TagOptionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionDetail> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionDetail ... tagOptions) {
            this.tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionDetail.Builder> ... tagOptions) {
            this.tagOptions(Stream.of(tagOptions).map(c -> (TagOptionDetail)((TagOptionDetail.Builder)TagOptionDetail.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionDetail.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copyFromBuilder(tagOptions);
        }

        @Override
        public DescribePortfolioResponse build() {
            return new DescribePortfolioResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribePortfolioResponse> {
        public Builder portfolioDetail(PortfolioDetail var1);

        default public Builder portfolioDetail(Consumer<PortfolioDetail.Builder> portfolioDetail) {
            return this.portfolioDetail((PortfolioDetail)((PortfolioDetail.Builder)PortfolioDetail.builder().apply(portfolioDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder tagOptions(Collection<TagOptionDetail> var1);

        public Builder tagOptions(TagOptionDetail ... var1);

        public Builder tagOptions(Consumer<TagOptionDetail.Builder> ... var1);
    }
}

