/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateProvisionedProductRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateProvisionedProductRequest> {
    private final String acceptLanguage;
    private final String provisionedProductName;
    private final String provisionedProductId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final List<UpdateProvisioningParameter> provisioningParameters;
    private final String updateToken;

    private UpdateProvisionedProductRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisioningParameters = builder.provisioningParameters;
        this.updateToken = builder.updateToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public String provisionedProductId() {
        return this.provisionedProductId;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    public List<UpdateProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductName() == null ? 0 : this.provisionedProductName().hashCode());
        hashCode = 31 * hashCode + (this.provisionedProductId() == null ? 0 : this.provisionedProductId().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactId() == null ? 0 : this.provisioningArtifactId().hashCode());
        hashCode = 31 * hashCode + (this.pathId() == null ? 0 : this.pathId().hashCode());
        hashCode = 31 * hashCode + (this.provisioningParameters() == null ? 0 : this.provisioningParameters().hashCode());
        hashCode = 31 * hashCode + (this.updateToken() == null ? 0 : this.updateToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductRequest)) {
            return false;
        }
        UpdateProvisionedProductRequest other = (UpdateProvisionedProductRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.provisionedProductName() == null ^ this.provisionedProductName() == null) {
            return false;
        }
        if (other.provisionedProductName() != null && !other.provisionedProductName().equals(this.provisionedProductName())) {
            return false;
        }
        if (other.provisionedProductId() == null ^ this.provisionedProductId() == null) {
            return false;
        }
        if (other.provisionedProductId() != null && !other.provisionedProductId().equals(this.provisionedProductId())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.provisioningArtifactId() == null ^ this.provisioningArtifactId() == null) {
            return false;
        }
        if (other.provisioningArtifactId() != null && !other.provisioningArtifactId().equals(this.provisioningArtifactId())) {
            return false;
        }
        if (other.pathId() == null ^ this.pathId() == null) {
            return false;
        }
        if (other.pathId() != null && !other.pathId().equals(this.pathId())) {
            return false;
        }
        if (other.provisioningParameters() == null ^ this.provisioningParameters() == null) {
            return false;
        }
        if (other.provisioningParameters() != null && !other.provisioningParameters().equals(this.provisioningParameters())) {
            return false;
        }
        if (other.updateToken() == null ^ this.updateToken() == null) {
            return false;
        }
        return other.updateToken() == null || other.updateToken().equals(this.updateToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.provisionedProductName() != null) {
            sb.append("ProvisionedProductName: ").append(this.provisionedProductName()).append(",");
        }
        if (this.provisionedProductId() != null) {
            sb.append("ProvisionedProductId: ").append(this.provisionedProductId()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.provisioningArtifactId() != null) {
            sb.append("ProvisioningArtifactId: ").append(this.provisioningArtifactId()).append(",");
        }
        if (this.pathId() != null) {
            sb.append("PathId: ").append(this.pathId()).append(",");
        }
        if (this.provisioningParameters() != null) {
            sb.append("ProvisioningParameters: ").append(this.provisioningParameters()).append(",");
        }
        if (this.updateToken() != null) {
            sb.append("UpdateToken: ").append(this.updateToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionedProductName;
        private String provisionedProductId;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private List<UpdateProvisioningParameter> provisioningParameters;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setProvisionedProductName(model.provisionedProductName);
            this.setProvisionedProductId(model.provisionedProductId);
            this.setProductId(model.productId);
            this.setProvisioningArtifactId(model.provisioningArtifactId);
            this.setPathId(model.pathId);
            this.setProvisioningParameters(model.provisioningParameters);
            this.setUpdateToken(model.updateToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final Collection<UpdateProvisioningParameter> getProvisioningParameters() {
            return this.provisioningParameters;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            if (this.provisioningParameters == null) {
                this.provisioningParameters = new ArrayList<UpdateProvisioningParameter>(provisioningParameters.length);
            }
            for (UpdateProvisioningParameter e : provisioningParameters) {
                this.provisioningParameters.add(e);
            }
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
        }

        @SafeVarargs
        public final void setProvisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            if (this.provisioningParameters == null) {
                this.provisioningParameters = new ArrayList<UpdateProvisioningParameter>(provisioningParameters.length);
            }
            for (UpdateProvisioningParameter e : provisioningParameters) {
                this.provisioningParameters.add(e);
            }
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        public UpdateProvisionedProductRequest build() {
            return new UpdateProvisionedProductRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateProvisionedProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisionedProductId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder provisioningParameters(Collection<UpdateProvisioningParameter> var1);

        public Builder provisioningParameters(UpdateProvisioningParameter ... var1);

        public Builder updateToken(String var1);
    }
}

