/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsAsAdminResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchProductsAsAdminResponse> {
    private final List<ProductViewDetail> productViewDetails;
    private final String nextPageToken;

    private SearchProductsAsAdminResponse(BuilderImpl builder) {
        this.productViewDetails = builder.productViewDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProductViewDetail> productViewDetails() {
        return this.productViewDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productViewDetails() == null ? 0 : this.productViewDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminResponse)) {
            return false;
        }
        SearchProductsAsAdminResponse other = (SearchProductsAsAdminResponse)((Object)obj);
        if (other.productViewDetails() == null ^ this.productViewDetails() == null) {
            return false;
        }
        if (other.productViewDetails() != null && !other.productViewDetails().equals(this.productViewDetails())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.productViewDetails() != null) {
            sb.append("ProductViewDetails: ").append(this.productViewDetails()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ProductViewDetail> productViewDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminResponse model) {
            this.setProductViewDetails(model.productViewDetails);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewDetail> getProductViewDetails() {
            return this.productViewDetails;
        }

        @Override
        public final Builder productViewDetails(Collection<ProductViewDetail> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copy(productViewDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(ProductViewDetail ... productViewDetails) {
            if (this.productViewDetails == null) {
                this.productViewDetails = new ArrayList<ProductViewDetail>(productViewDetails.length);
            }
            for (ProductViewDetail e : productViewDetails) {
                this.productViewDetails.add(e);
            }
            return this;
        }

        public final void setProductViewDetails(Collection<ProductViewDetail> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copy(productViewDetails);
        }

        @SafeVarargs
        public final void setProductViewDetails(ProductViewDetail ... productViewDetails) {
            if (this.productViewDetails == null) {
                this.productViewDetails = new ArrayList<ProductViewDetail>(productViewDetails.length);
            }
            for (ProductViewDetail e : productViewDetails) {
                this.productViewDetails.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public SearchProductsAsAdminResponse build() {
            return new SearchProductsAsAdminResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchProductsAsAdminResponse> {
        public Builder productViewDetails(Collection<ProductViewDetail> var1);

        public Builder productViewDetails(ProductViewDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

