/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.transform.ProductViewAggregationValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProductViewAggregationValue
implements StructuredPojo,
ToCopyableBuilder<Builder, ProductViewAggregationValue> {
    private final String value;
    private final Integer approximateCount;

    private ProductViewAggregationValue(BuilderImpl builder) {
        this.value = builder.value;
        this.approximateCount = builder.approximateCount;
    }

    public String value() {
        return this.value;
    }

    public Integer approximateCount() {
        return this.approximateCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.approximateCount() == null ? 0 : this.approximateCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewAggregationValue)) {
            return false;
        }
        ProductViewAggregationValue other = (ProductViewAggregationValue)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.approximateCount() == null ^ this.approximateCount() == null) {
            return false;
        }
        return other.approximateCount() == null || other.approximateCount().equals(this.approximateCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.approximateCount() != null) {
            sb.append("ApproximateCount: ").append(this.approximateCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductViewAggregationValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String value;
        private Integer approximateCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewAggregationValue model) {
            this.setValue(model.value);
            this.setApproximateCount(model.approximateCount);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Integer getApproximateCount() {
            return this.approximateCount;
        }

        @Override
        public final Builder approximateCount(Integer approximateCount) {
            this.approximateCount = approximateCount;
            return this;
        }

        public final void setApproximateCount(Integer approximateCount) {
            this.approximateCount = approximateCount;
        }

        public ProductViewAggregationValue build() {
            return new ProductViewAggregationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductViewAggregationValue> {
        public Builder value(String var1);

        public Builder approximateCount(Integer var1);
    }
}

